

<?php $__env->startSection('title', 'Upgrade'); ?>
<?php $__env->startSection('subtitle', 'Upgrade your application to the latest version'); ?>

<?php $__env->startSection('content'); ?>
    <div style="text-align: center;">
        <div class="welcome-icon">
            <i class="fas fa-sync-alt"></i>
        </div>
        
        <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Application Upgrade</h2>
        
        <div class="info-card" style="max-width: 450px; margin: 0 auto var(--spacing-xl) auto; text-align: left;">
            <h3><i class="fas fa-info-circle"></i> Current Version</h3>
            
            <div class="info-item">
                <div class="info-label">Version</div>
                <div class="info-value"><?php echo e($currentVersion); ?></div>
            </div>
            
            <div class="info-item">
                <div class="info-label">Status</div>
                <div class="info-value">
                    <?php if($upgradeInProgress): ?>
                        <span style="color: var(--warning);">
                            <i class="fas fa-exclamation-triangle"></i> Upgrade in progress
                        </span>
                    <?php else: ?>
                        <span style="color: var(--success);">
                            <i class="fas fa-check-circle"></i> Running
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <?php if($upgradeInProgress): ?>
            <div class="alert alert-warning" style="text-align: left; margin-bottom: var(--spacing-xl);">
                <i class="fas fa-exclamation-triangle"></i>
                <div>
                    <strong>Upgrade In Progress</strong>
                    <p style="margin-top: var(--spacing-xs);">
                        An upgrade is currently in progress. If the upgrade failed, you can <a href="<?php echo e(route('upgrade.rollback')); ?>" style="color: var(--primary-color); text-decoration: underline;">rollback to the previous version</a>.
                    </p>
                </div>
            </div>
        <?php endif; ?>
        
        <p style="margin-bottom: var(--spacing-lg);">
            Upload an upgrade package to update your application to a newer version.
        </p>
    </div>
    
    <form action="<?php echo e(route('upgrade.upload')); ?>" method="POST" enctype="multipart/form-data" id="uploadForm">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
            <label for="upgrade_package" class="form-label">
                <i class="fas fa-file-archive" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Upgrade Package
            </label>
            <input type="file" id="upgrade_package" name="upgrade_package" class="form-control" accept=".zip" required>
            <?php if($errors->has('upgrade_package')): ?>
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    <?php echo e($errors->first('upgrade_package')); ?>

                </div>
            <?php endif; ?>
            <div style="font-size: 0.85rem; color: var(--light-gray); margin-top: var(--spacing-xs);">
                Upload the official upgrade package (ZIP file, max 500MB).
            </div>
        </div>
        
        <div style="margin-top: var(--spacing-lg); background-color: rgba(255, 193, 7, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-md); border: 1px solid rgba(255, 193, 7, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-exclamation-triangle" style="color: var(--warning); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <div style="font-size: 0.9rem;">
                    <p style="margin-bottom: var(--spacing-xs); font-weight: 500;">Important Notes:</p>
                    <ul style="padding-left: var(--spacing-lg); margin: 0;">
                        <li style="margin-bottom: var(--spacing-xs);">Always backup your files and database before upgrading</li>
                        <li style="margin-bottom: var(--spacing-xs);">The upgrade process will automatically create a backup</li>
                        <li style="margin-bottom: var(--spacing-xs);">Do not close this window during the upgrade</li>
                        <li>Your custom files in storage/ and public/uploads/ will be preserved</li>
                    </ul>
                </div>
            </div>
        </div>
    </form>
    
    <?php if(count($backups) > 0): ?>
        <div style="margin-top: var(--spacing-xxl);">
            <h3 style="color: var(--white); margin-bottom: var(--spacing-md);">
                <i class="fas fa-history"></i> Available Backups
            </h3>
            
            <div class="info-card">
                <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="info-item">
                        <div>
                            <div style="font-weight: 500; color: var(--white); margin-bottom: var(--spacing-xs);">
                                <?php echo e($backup['name']); ?>

                            </div>
                            <div style="font-size: 0.85rem; color: var(--light-gray);">
                                Version <?php echo e($backup['version']); ?> • <?php echo e($backup['created_at']); ?> • <?php echo e($backup['size']); ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <div></div>
    <button type="submit" form="uploadForm" class="btn btn-primary" id="uploadBtn">
        <i class="fas fa-upload"></i> Upload Package
    </button>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.getElementById('uploadForm').addEventListener('submit', function() {
        document.getElementById('uploadBtn').disabled = true;
        document.getElementById('uploadBtn').innerHTML = '<i class="fas fa-spin fa-spinner"></i> Uploading...';
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('upgrade.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/upgrade/index.blade.php ENDPATH**/ ?>